/* shortcuts.c generated by valac 0.56.18, the Vala compiler
 * generated from shortcuts.vala, do not modify */

/* Copyright 2017 Siddhartha Das (bablu.boy@gmail.com)
*
* This file is part of Bookworm and is used for defining
* the keyboard shortcuts for Bookworm
*
* Bookworm is free software: you can redistribute it
* and/or modify it under the terms of the GNU General Public License as
* published by the Free Software Foundation, either version 3 of the
* License, or (at your option) any later version.
*
* Bookworm is distributed in the hope that it will be
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
* Public License for more details.
*
* You should have received a copy of the GNU General Public License along
* with Bookworm. If not, see http://www.gnu.org/licenses/.
*/

#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib.h>
#include <granite.h>
#include <gdk/gdk.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <glib/gi18n-lib.h>
#include <webkit2/webkit2.h>
#include <float.h>
#include <math.h>

#define BOOKWORM_APP_CONSTANTS_TEXT_FOR_SUBTITLE_HEADERBAR _ ("eBook Reader")
#define BOOKWORM_APP_CONSTANTS_ZOOM_CHANGE_VALUE 0.1
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define BOOKWORM_APP_TYPE_SHORTCUTS (bookworm_app_shortcuts_get_type ())
#define BOOKWORM_APP_SHORTCUTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOOKWORM_APP_TYPE_SHORTCUTS, BookwormAppShortcuts))
#define BOOKWORM_APP_SHORTCUTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOOKWORM_APP_TYPE_SHORTCUTS, BookwormAppShortcutsClass))
#define BOOKWORM_APP_IS_SHORTCUTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOOKWORM_APP_TYPE_SHORTCUTS))
#define BOOKWORM_APP_IS_SHORTCUTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOOKWORM_APP_TYPE_SHORTCUTS))
#define BOOKWORM_APP_SHORTCUTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOOKWORM_APP_TYPE_SHORTCUTS, BookwormAppShortcutsClass))

typedef struct _BookwormAppShortcuts BookwormAppShortcuts;
typedef struct _BookwormAppShortcutsClass BookwormAppShortcutsClass;
typedef struct _BookwormAppShortcutsPrivate BookwormAppShortcutsPrivate;
enum  {
	BOOKWORM_APP_SHORTCUTS_0_PROPERTY,
	BOOKWORM_APP_SHORTCUTS_NUM_PROPERTIES
};
static GParamSpec* bookworm_app_shortcuts_properties[BOOKWORM_APP_SHORTCUTS_NUM_PROPERTIES];

#define BOOKWORM_APP_TYPE_SETTINGS (bookworm_app_settings_get_type ())
#define BOOKWORM_APP_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOOKWORM_APP_TYPE_SETTINGS, BookwormAppSettings))
#define BOOKWORM_APP_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOOKWORM_APP_TYPE_SETTINGS, BookwormAppSettingsClass))
#define BOOKWORM_APP_IS_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOOKWORM_APP_TYPE_SETTINGS))
#define BOOKWORM_APP_IS_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOOKWORM_APP_TYPE_SETTINGS))
#define BOOKWORM_APP_SETTINGS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOOKWORM_APP_TYPE_SETTINGS, BookwormAppSettingsClass))

typedef struct _BookwormAppSettings BookwormAppSettings;
typedef struct _BookwormAppSettingsClass BookwormAppSettingsClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define BOOKWORM_APP_TYPE_BOOK (bookworm_app_book_get_type ())
#define BOOKWORM_APP_BOOK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOOKWORM_APP_TYPE_BOOK, BookwormAppBook))
#define BOOKWORM_APP_BOOK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOOKWORM_APP_TYPE_BOOK, BookwormAppBookClass))
#define BOOKWORM_APP_IS_BOOK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOOKWORM_APP_TYPE_BOOK))
#define BOOKWORM_APP_IS_BOOK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOOKWORM_APP_TYPE_BOOK))
#define BOOKWORM_APP_BOOK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOOKWORM_APP_TYPE_BOOK, BookwormAppBookClass))

typedef struct _BookwormAppBook BookwormAppBook;
typedef struct _BookwormAppBookClass BookwormAppBookClass;
#define _bookworm_app_book_unref0(var) ((var == NULL) ? NULL : (var = (bookworm_app_book_unref (var), NULL)))

struct _BookwormAppShortcuts {
	GtkWidget parent_instance;
	BookwormAppShortcutsPrivate * priv;
};

struct _BookwormAppShortcutsClass {
	GtkWidgetClass parent_class;
};

static gpointer bookworm_app_shortcuts_parent_class = NULL;
VALA_EXTERN gboolean bookworm_app_shortcuts_isControlKeyPressed;
gboolean bookworm_app_shortcuts_isControlKeyPressed = FALSE;
VALA_EXTERN BookwormAppSettings* bookworm_app_shortcuts_settings;
BookwormAppSettings* bookworm_app_shortcuts_settings = NULL;
VALA_EXTERN gchar* bookworm_app_bookworm_BOOKWORM_CURRENT_STATE;
VALA_EXTERN GeeHashMap* bookworm_app_bookworm_libraryViewMap;
VALA_EXTERN gchar* bookworm_app_bookworm_locationOfEBookCurrentlyRead;
VALA_EXTERN GtkHeaderBar* bookworm_app_app_header_bar_headerbar;
VALA_EXTERN WebKitWebView* bookworm_app_app_window_aWebView;
VALA_EXTERN GtkButton* bookworm_app_app_header_bar_bookmark_inactive_button;
VALA_EXTERN GtkBox* bookworm_app_app_window_book_reading_footer_box;
VALA_EXTERN GtkApplicationWindow* bookworm_app_bookworm_window;
VALA_EXTERN GtkSearchEntry* bookworm_app_app_header_bar_headerSearchBar;

VALA_EXTERN GType bookworm_app_shortcuts_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BookwormAppShortcuts, g_object_unref)
VALA_EXTERN GType bookworm_app_settings_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BookwormAppSettings, g_object_unref)
VALA_EXTERN gboolean bookworm_app_shortcuts_handleKeyPress (GdkEventKey* ev);
VALA_EXTERN BookwormAppSettings* bookworm_app_settings_get_instance (void);
VALA_EXTERN const gchar* bookworm_app_settings_get_library_view_mode (BookwormAppSettings* self);
VALA_EXTERN void bookworm_app_settings_set_library_view_mode (BookwormAppSettings* self,
                                                  const gchar* value);
VALA_EXTERN void bookworm_app_bookworm_toggleUIState (void);
VALA_EXTERN void bookworm_app_app_window_handleLibraryPageButtons (const gchar* mode,
                                                       gboolean isPaginateRequired);
VALA_EXTERN gpointer bookworm_app_book_ref (gpointer instance);
VALA_EXTERN void bookworm_app_book_unref (gpointer instance);
VALA_EXTERN GParamSpec* bookworm_app_param_spec_book (const gchar* name,
                                          const gchar* nick,
                                          const gchar* blurb,
                                          GType object_type,
                                          GParamFlags flags);
VALA_EXTERN void bookworm_app_value_set_book (GValue* value,
                                  gpointer v_object);
VALA_EXTERN void bookworm_app_value_take_book (GValue* value,
                                   gpointer v_object);
VALA_EXTERN gpointer bookworm_app_value_get_book (const GValue* value);
VALA_EXTERN GType bookworm_app_book_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BookwormAppBook, bookworm_app_book_unref)
VALA_EXTERN void bookworm_app_book_setBookScrollPos (BookwormAppBook* self,
                                         gint aBookScrollPos);
VALA_EXTERN gint bookworm_app_content_handler_getScrollPos (void);
VALA_EXTERN BookwormAppBook* bookworm_app_content_handler_renderPage (BookwormAppBook* aBook,
                                                          gchar* direction);
VALA_EXTERN gchar* bookworm_app_book_getBookLocation (BookwormAppBook* self);
VALA_EXTERN void bookworm_app_content_handler_handleBookMark (const gchar* action);
VALA_EXTERN gboolean bookworm_app_settings_get_is_fullscreen (BookwormAppSettings* self);
VALA_EXTERN gboolean bookworm_app_shortcuts_handleKeyRelease (GdkEventKey* ev);
VALA_EXTERN BookwormAppShortcuts* bookworm_app_shortcuts_new (void);
VALA_EXTERN BookwormAppShortcuts* bookworm_app_shortcuts_construct (GType object_type);
static void bookworm_app_shortcuts_finalize (GObject * obj);
static GType bookworm_app_shortcuts_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

VALA_EXTERN const gchar* BOOKWORM_APP_CONSTANTS_BOOKWORM_UI_STATES[8];

static gpointer
_bookworm_app_book_ref0 (gpointer self)
{
#line 71 "../src/shortcuts.vala"
	return self ? bookworm_app_book_ref (self) : NULL;
#line 169 "shortcuts.c"
}

gboolean
bookworm_app_shortcuts_handleKeyPress (GdkEventKey* ev)
{
	BookwormAppSettings* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp19_;
	const gchar* _tmp20_;
	gboolean _tmp74_ = FALSE;
	gboolean _tmp77_ = FALSE;
	gboolean result;
#line 24 "../src/shortcuts.vala"
	g_return_val_if_fail (ev != NULL, FALSE);
#line 25 "../src/shortcuts.vala"
	_tmp0_ = bookworm_app_settings_get_instance ();
#line 25 "../src/shortcuts.vala"
	_g_object_unref0 (bookworm_app_shortcuts_settings);
#line 25 "../src/shortcuts.vala"
	bookworm_app_shortcuts_settings = _tmp0_;
#line 27 "../src/shortcuts.vala"
	if (ev->keyval == GDK_KEY_Control_L) {
#line 27 "../src/shortcuts.vala"
		_tmp1_ = TRUE;
#line 197 "shortcuts.c"
	} else {
#line 27 "../src/shortcuts.vala"
		_tmp1_ = ev->keyval == GDK_KEY_Control_R;
#line 201 "shortcuts.c"
	}
#line 27 "../src/shortcuts.vala"
	if (_tmp1_) {
#line 28 "../src/shortcuts.vala"
		bookworm_app_shortcuts_isControlKeyPressed = TRUE;
#line 207 "shortcuts.c"
	}
#line 31 "../src/shortcuts.vala"
	_tmp3_ = bookworm_app_bookworm_BOOKWORM_CURRENT_STATE;
#line 31 "../src/shortcuts.vala"
	_tmp4_ = BOOKWORM_APP_CONSTANTS_BOOKWORM_UI_STATES[0];
#line 31 "../src/shortcuts.vala"
	if (g_strcmp0 (_tmp3_, _tmp4_) == 0) {
#line 31 "../src/shortcuts.vala"
		_tmp2_ = TRUE;
#line 217 "shortcuts.c"
	} else {
		const gchar* _tmp5_;
		const gchar* _tmp6_;
#line 32 "../src/shortcuts.vala"
		_tmp5_ = bookworm_app_bookworm_BOOKWORM_CURRENT_STATE;
#line 32 "../src/shortcuts.vala"
		_tmp6_ = BOOKWORM_APP_CONSTANTS_BOOKWORM_UI_STATES[5];
#line 32 "../src/shortcuts.vala"
		_tmp2_ = g_strcmp0 (_tmp5_, _tmp6_) == 0;
#line 227 "shortcuts.c"
	}
#line 31 "../src/shortcuts.vala"
	if (_tmp2_) {
#line 231 "shortcuts.c"
		gboolean _tmp7_ = FALSE;
#line 34 "../src/shortcuts.vala"
		if (bookworm_app_shortcuts_isControlKeyPressed) {
#line 235 "shortcuts.c"
			gboolean _tmp8_ = FALSE;
#line 34 "../src/shortcuts.vala"
			if (ev->keyval == GDK_KEY_V) {
#line 34 "../src/shortcuts.vala"
				_tmp8_ = TRUE;
#line 241 "shortcuts.c"
			} else {
#line 34 "../src/shortcuts.vala"
				_tmp8_ = ev->keyval == GDK_KEY_v;
#line 245 "shortcuts.c"
			}
#line 34 "../src/shortcuts.vala"
			_tmp7_ = _tmp8_;
#line 249 "shortcuts.c"
		} else {
#line 34 "../src/shortcuts.vala"
			_tmp7_ = FALSE;
#line 253 "shortcuts.c"
		}
#line 34 "../src/shortcuts.vala"
		if (_tmp7_) {
#line 257 "shortcuts.c"
			BookwormAppSettings* _tmp9_;
			const gchar* _tmp10_;
			const gchar* _tmp11_;
			const gchar* _tmp12_;
			BookwormAppSettings* _tmp17_;
			const gchar* _tmp18_;
#line 35 "../src/shortcuts.vala"
			bookworm_app_shortcuts_isControlKeyPressed = FALSE;
#line 36 "../src/shortcuts.vala"
			_tmp9_ = bookworm_app_shortcuts_settings;
#line 36 "../src/shortcuts.vala"
			_tmp10_ = bookworm_app_settings_get_library_view_mode (_tmp9_);
#line 36 "../src/shortcuts.vala"
			_tmp11_ = _tmp10_;
#line 36 "../src/shortcuts.vala"
			_tmp12_ = BOOKWORM_APP_CONSTANTS_BOOKWORM_UI_STATES[5];
#line 36 "../src/shortcuts.vala"
			if (g_strcmp0 (_tmp11_, _tmp12_) == 0) {
#line 276 "shortcuts.c"
				const gchar* _tmp13_;
				gchar* _tmp14_;
#line 37 "../src/shortcuts.vala"
				_tmp13_ = BOOKWORM_APP_CONSTANTS_BOOKWORM_UI_STATES[0];
#line 37 "../src/shortcuts.vala"
				_tmp14_ = g_strdup (_tmp13_);
#line 37 "../src/shortcuts.vala"
				_g_free0 (bookworm_app_bookworm_BOOKWORM_CURRENT_STATE);
#line 37 "../src/shortcuts.vala"
				bookworm_app_bookworm_BOOKWORM_CURRENT_STATE = _tmp14_;
#line 287 "shortcuts.c"
			} else {
				const gchar* _tmp15_;
				gchar* _tmp16_;
#line 39 "../src/shortcuts.vala"
				_tmp15_ = BOOKWORM_APP_CONSTANTS_BOOKWORM_UI_STATES[5];
#line 39 "../src/shortcuts.vala"
				_tmp16_ = g_strdup (_tmp15_);
#line 39 "../src/shortcuts.vala"
				_g_free0 (bookworm_app_bookworm_BOOKWORM_CURRENT_STATE);
#line 39 "../src/shortcuts.vala"
				bookworm_app_bookworm_BOOKWORM_CURRENT_STATE = _tmp16_;
#line 299 "shortcuts.c"
			}
#line 41 "../src/shortcuts.vala"
			_tmp17_ = bookworm_app_shortcuts_settings;
#line 41 "../src/shortcuts.vala"
			_tmp18_ = bookworm_app_bookworm_BOOKWORM_CURRENT_STATE;
#line 41 "../src/shortcuts.vala"
			bookworm_app_settings_set_library_view_mode (_tmp17_, _tmp18_);
#line 42 "../src/shortcuts.vala"
			bookworm_app_bookworm_toggleUIState ();
#line 309 "shortcuts.c"
		}
#line 45 "../src/shortcuts.vala"
		if (ev->keyval == GDK_KEY_Left) {
#line 46 "../src/shortcuts.vala"
			bookworm_app_app_window_handleLibraryPageButtons ("PREV_PAGE", TRUE);
#line 315 "shortcuts.c"
		}
#line 49 "../src/shortcuts.vala"
		if (ev->keyval == GDK_KEY_Right) {
#line 50 "../src/shortcuts.vala"
			bookworm_app_app_window_handleLibraryPageButtons ("NEXT_PAGE", TRUE);
#line 321 "shortcuts.c"
		}
	}
#line 54 "../src/shortcuts.vala"
	_tmp19_ = bookworm_app_bookworm_BOOKWORM_CURRENT_STATE;
#line 54 "../src/shortcuts.vala"
	_tmp20_ = BOOKWORM_APP_CONSTANTS_BOOKWORM_UI_STATES[1];
#line 54 "../src/shortcuts.vala"
	if (g_strcmp0 (_tmp19_, _tmp20_) == 0) {
#line 330 "shortcuts.c"
		gboolean _tmp21_ = FALSE;
		gboolean _tmp56_ = FALSE;
		gboolean _tmp59_ = FALSE;
		gboolean _tmp62_ = FALSE;
#line 56 "../src/shortcuts.vala"
		if (bookworm_app_shortcuts_isControlKeyPressed) {
#line 337 "shortcuts.c"
			gboolean _tmp22_ = FALSE;
#line 56 "../src/shortcuts.vala"
			if (ev->keyval == GDK_KEY_L) {
#line 56 "../src/shortcuts.vala"
				_tmp22_ = TRUE;
#line 343 "shortcuts.c"
			} else {
#line 56 "../src/shortcuts.vala"
				_tmp22_ = ev->keyval == GDK_KEY_l;
#line 347 "shortcuts.c"
			}
#line 56 "../src/shortcuts.vala"
			_tmp21_ = _tmp22_;
#line 351 "shortcuts.c"
		} else {
#line 56 "../src/shortcuts.vala"
			_tmp21_ = FALSE;
#line 355 "shortcuts.c"
		}
#line 56 "../src/shortcuts.vala"
		if (_tmp21_) {
#line 359 "shortcuts.c"
			GeeHashMap* _tmp23_;
			const gchar* _tmp24_;
			gpointer _tmp25_;
			BookwormAppBook* _tmp26_;
			GtkHeaderBar* _tmp27_;
			BookwormAppSettings* _tmp28_;
			const gchar* _tmp29_;
			const gchar* _tmp30_;
			gchar* _tmp31_;
#line 58 "../src/shortcuts.vala"
			_tmp23_ = bookworm_app_bookworm_libraryViewMap;
#line 58 "../src/shortcuts.vala"
			_tmp24_ = bookworm_app_bookworm_locationOfEBookCurrentlyRead;
#line 58 "../src/shortcuts.vala"
			_tmp25_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp23_, _tmp24_);
#line 58 "../src/shortcuts.vala"
			_tmp26_ = (BookwormAppBook*) _tmp25_;
#line 58 "../src/shortcuts.vala"
			bookworm_app_book_setBookScrollPos (_tmp26_, bookworm_app_content_handler_getScrollPos ());
#line 58 "../src/shortcuts.vala"
			_bookworm_app_book_unref0 (_tmp26_);
#line 62 "../src/shortcuts.vala"
			_tmp27_ = bookworm_app_app_header_bar_headerbar;
#line 62 "../src/shortcuts.vala"
			gtk_header_bar_set_title (_tmp27_, BOOKWORM_APP_CONSTANTS_TEXT_FOR_SUBTITLE_HEADERBAR);
#line 64 "../src/shortcuts.vala"
			_tmp28_ = bookworm_app_shortcuts_settings;
#line 64 "../src/shortcuts.vala"
			_tmp29_ = bookworm_app_settings_get_library_view_mode (_tmp28_);
#line 64 "../src/shortcuts.vala"
			_tmp30_ = _tmp29_;
#line 64 "../src/shortcuts.vala"
			_tmp31_ = g_strdup (_tmp30_);
#line 64 "../src/shortcuts.vala"
			_g_free0 (bookworm_app_bookworm_BOOKWORM_CURRENT_STATE);
#line 64 "../src/shortcuts.vala"
			bookworm_app_bookworm_BOOKWORM_CURRENT_STATE = _tmp31_;
#line 65 "../src/shortcuts.vala"
			bookworm_app_bookworm_toggleUIState ();
#line 399 "shortcuts.c"
		}
#line 68 "../src/shortcuts.vala"
		if (ev->keyval == GDK_KEY_Left) {
#line 403 "shortcuts.c"
			BookwormAppBook* aBookLeftKeyPress = NULL;
			GeeHashMap* _tmp32_;
			const gchar* _tmp33_;
			gpointer _tmp34_;
			BookwormAppBook* _tmp35_;
			BookwormAppBook* _tmp36_;
			gchar* _tmp37_;
			BookwormAppBook* _tmp38_;
			GeeHashMap* _tmp39_;
			BookwormAppBook* _tmp40_;
			gchar* _tmp41_;
			gchar* _tmp42_;
			BookwormAppBook* _tmp43_;
#line 70 "../src/shortcuts.vala"
			_tmp32_ = bookworm_app_bookworm_libraryViewMap;
#line 70 "../src/shortcuts.vala"
			_tmp33_ = bookworm_app_bookworm_locationOfEBookCurrentlyRead;
#line 70 "../src/shortcuts.vala"
			_tmp34_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp32_, _tmp33_);
#line 70 "../src/shortcuts.vala"
			aBookLeftKeyPress = (BookwormAppBook*) _tmp34_;
#line 71 "../src/shortcuts.vala"
			_tmp35_ = aBookLeftKeyPress;
#line 71 "../src/shortcuts.vala"
			_tmp36_ = _bookworm_app_book_ref0 (_tmp35_);
#line 71 "../src/shortcuts.vala"
			_tmp37_ = g_strdup ("BACKWARD");
#line 71 "../src/shortcuts.vala"
			_tmp38_ = bookworm_app_content_handler_renderPage (_tmp36_, _tmp37_);
#line 71 "../src/shortcuts.vala"
			_bookworm_app_book_unref0 (aBookLeftKeyPress);
#line 71 "../src/shortcuts.vala"
			aBookLeftKeyPress = _tmp38_;
#line 73 "../src/shortcuts.vala"
			_tmp39_ = bookworm_app_bookworm_libraryViewMap;
#line 73 "../src/shortcuts.vala"
			_tmp40_ = aBookLeftKeyPress;
#line 73 "../src/shortcuts.vala"
			_tmp41_ = bookworm_app_book_getBookLocation (_tmp40_);
#line 73 "../src/shortcuts.vala"
			_tmp42_ = _tmp41_;
#line 73 "../src/shortcuts.vala"
			_tmp43_ = aBookLeftKeyPress;
#line 73 "../src/shortcuts.vala"
			gee_abstract_map_set ((GeeAbstractMap*) _tmp39_, _tmp42_, _tmp43_);
#line 73 "../src/shortcuts.vala"
			_g_free0 (_tmp42_);
#line 68 "../src/shortcuts.vala"
			_bookworm_app_book_unref0 (aBookLeftKeyPress);
#line 453 "shortcuts.c"
		}
#line 76 "../src/shortcuts.vala"
		if (ev->keyval == GDK_KEY_Right) {
#line 457 "shortcuts.c"
			BookwormAppBook* aBookRightKeyPress = NULL;
			GeeHashMap* _tmp44_;
			const gchar* _tmp45_;
			gpointer _tmp46_;
			BookwormAppBook* _tmp47_;
			BookwormAppBook* _tmp48_;
			gchar* _tmp49_;
			BookwormAppBook* _tmp50_;
			GeeHashMap* _tmp51_;
			BookwormAppBook* _tmp52_;
			gchar* _tmp53_;
			gchar* _tmp54_;
			BookwormAppBook* _tmp55_;
#line 78 "../src/shortcuts.vala"
			_tmp44_ = bookworm_app_bookworm_libraryViewMap;
#line 78 "../src/shortcuts.vala"
			_tmp45_ = bookworm_app_bookworm_locationOfEBookCurrentlyRead;
#line 78 "../src/shortcuts.vala"
			_tmp46_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp44_, _tmp45_);
#line 78 "../src/shortcuts.vala"
			aBookRightKeyPress = (BookwormAppBook*) _tmp46_;
#line 79 "../src/shortcuts.vala"
			_tmp47_ = aBookRightKeyPress;
#line 79 "../src/shortcuts.vala"
			_tmp48_ = _bookworm_app_book_ref0 (_tmp47_);
#line 79 "../src/shortcuts.vala"
			_tmp49_ = g_strdup ("FORWARD");
#line 79 "../src/shortcuts.vala"
			_tmp50_ = bookworm_app_content_handler_renderPage (_tmp48_, _tmp49_);
#line 79 "../src/shortcuts.vala"
			_bookworm_app_book_unref0 (aBookRightKeyPress);
#line 79 "../src/shortcuts.vala"
			aBookRightKeyPress = _tmp50_;
#line 81 "../src/shortcuts.vala"
			_tmp51_ = bookworm_app_bookworm_libraryViewMap;
#line 81 "../src/shortcuts.vala"
			_tmp52_ = aBookRightKeyPress;
#line 81 "../src/shortcuts.vala"
			_tmp53_ = bookworm_app_book_getBookLocation (_tmp52_);
#line 81 "../src/shortcuts.vala"
			_tmp54_ = _tmp53_;
#line 81 "../src/shortcuts.vala"
			_tmp55_ = aBookRightKeyPress;
#line 81 "../src/shortcuts.vala"
			gee_abstract_map_set ((GeeAbstractMap*) _tmp51_, _tmp54_, _tmp55_);
#line 81 "../src/shortcuts.vala"
			_g_free0 (_tmp54_);
#line 76 "../src/shortcuts.vala"
			_bookworm_app_book_unref0 (aBookRightKeyPress);
#line 507 "shortcuts.c"
		}
#line 84 "../src/shortcuts.vala"
		if (bookworm_app_shortcuts_isControlKeyPressed) {
#line 84 "../src/shortcuts.vala"
			_tmp56_ = ev->keyval == GDK_KEY_plus;
#line 513 "shortcuts.c"
		} else {
#line 84 "../src/shortcuts.vala"
			_tmp56_ = FALSE;
#line 517 "shortcuts.c"
		}
#line 84 "../src/shortcuts.vala"
		if (_tmp56_) {
#line 521 "shortcuts.c"
			WebKitWebView* _tmp57_;
			WebKitWebView* _tmp58_;
#line 85 "../src/shortcuts.vala"
			_tmp57_ = bookworm_app_app_window_aWebView;
#line 85 "../src/shortcuts.vala"
			_tmp58_ = bookworm_app_app_window_aWebView;
#line 85 "../src/shortcuts.vala"
			webkit_web_view_set_zoom_level (_tmp57_, webkit_web_view_get_zoom_level (_tmp58_) + BOOKWORM_APP_CONSTANTS_ZOOM_CHANGE_VALUE);
#line 530 "shortcuts.c"
		}
#line 88 "../src/shortcuts.vala"
		if (bookworm_app_shortcuts_isControlKeyPressed) {
#line 88 "../src/shortcuts.vala"
			_tmp59_ = ev->keyval == GDK_KEY_minus;
#line 536 "shortcuts.c"
		} else {
#line 88 "../src/shortcuts.vala"
			_tmp59_ = FALSE;
#line 540 "shortcuts.c"
		}
#line 88 "../src/shortcuts.vala"
		if (_tmp59_) {
#line 544 "shortcuts.c"
			WebKitWebView* _tmp60_;
			WebKitWebView* _tmp61_;
#line 89 "../src/shortcuts.vala"
			_tmp60_ = bookworm_app_app_window_aWebView;
#line 89 "../src/shortcuts.vala"
			_tmp61_ = bookworm_app_app_window_aWebView;
#line 89 "../src/shortcuts.vala"
			webkit_web_view_set_zoom_level (_tmp60_, webkit_web_view_get_zoom_level (_tmp61_) - BOOKWORM_APP_CONSTANTS_ZOOM_CHANGE_VALUE);
#line 553 "shortcuts.c"
		}
#line 92 "../src/shortcuts.vala"
		if (bookworm_app_shortcuts_isControlKeyPressed) {
#line 557 "shortcuts.c"
			gboolean _tmp63_ = FALSE;
#line 92 "../src/shortcuts.vala"
			if (ev->keyval == GDK_KEY_D) {
#line 92 "../src/shortcuts.vala"
				_tmp63_ = TRUE;
#line 563 "shortcuts.c"
			} else {
#line 92 "../src/shortcuts.vala"
				_tmp63_ = ev->keyval == GDK_KEY_d;
#line 567 "shortcuts.c"
			}
#line 92 "../src/shortcuts.vala"
			_tmp62_ = _tmp63_;
#line 571 "shortcuts.c"
		} else {
#line 92 "../src/shortcuts.vala"
			_tmp62_ = FALSE;
#line 575 "shortcuts.c"
		}
#line 92 "../src/shortcuts.vala"
		if (_tmp62_) {
#line 579 "shortcuts.c"
			GtkButton* _tmp64_;
#line 94 "../src/shortcuts.vala"
			_tmp64_ = bookworm_app_app_header_bar_bookmark_inactive_button;
#line 94 "../src/shortcuts.vala"
			if (gtk_widget_get_visible ((GtkWidget*) _tmp64_)) {
#line 95 "../src/shortcuts.vala"
				bookworm_app_content_handler_handleBookMark ("INACTIVE_CLICKED");
#line 96 "../src/shortcuts.vala"
				bookworm_app_shortcuts_isControlKeyPressed = FALSE;
#line 589 "shortcuts.c"
			} else {
#line 99 "../src/shortcuts.vala"
				bookworm_app_content_handler_handleBookMark ("ACTIVE_CLICKED");
#line 100 "../src/shortcuts.vala"
				bookworm_app_shortcuts_isControlKeyPressed = FALSE;
#line 595 "shortcuts.c"
			}
		}
	}
#line 106 "../src/shortcuts.vala"
	if (ev->keyval == GDK_KEY_Escape) {
#line 601 "shortcuts.c"
		GtkBox* _tmp65_;
		GtkApplicationWindow* _tmp66_;
#line 107 "../src/shortcuts.vala"
		_tmp65_ = bookworm_app_app_window_book_reading_footer_box;
#line 107 "../src/shortcuts.vala"
		gtk_widget_show ((GtkWidget*) _tmp65_);
#line 108 "../src/shortcuts.vala"
		_tmp66_ = bookworm_app_bookworm_window;
#line 108 "../src/shortcuts.vala"
		gtk_window_unfullscreen ((GtkWindow*) _tmp66_);
#line 612 "shortcuts.c"
	}
#line 111 "../src/shortcuts.vala"
	if (ev->keyval == GDK_KEY_F11) {
#line 616 "shortcuts.c"
		BookwormAppSettings* _tmp67_;
		gboolean _tmp68_;
		gboolean _tmp69_;
#line 112 "../src/shortcuts.vala"
		_tmp67_ = bookworm_app_shortcuts_settings;
#line 112 "../src/shortcuts.vala"
		_tmp68_ = bookworm_app_settings_get_is_fullscreen (_tmp67_);
#line 112 "../src/shortcuts.vala"
		_tmp69_ = _tmp68_;
#line 112 "../src/shortcuts.vala"
		if (_tmp69_) {
#line 628 "shortcuts.c"
			GtkBox* _tmp70_;
			GtkApplicationWindow* _tmp71_;
#line 113 "../src/shortcuts.vala"
			_tmp70_ = bookworm_app_app_window_book_reading_footer_box;
#line 113 "../src/shortcuts.vala"
			gtk_widget_show ((GtkWidget*) _tmp70_);
#line 114 "../src/shortcuts.vala"
			_tmp71_ = bookworm_app_bookworm_window;
#line 114 "../src/shortcuts.vala"
			gtk_window_unfullscreen ((GtkWindow*) _tmp71_);
#line 639 "shortcuts.c"
		} else {
			GtkBox* _tmp72_;
			GtkApplicationWindow* _tmp73_;
#line 116 "../src/shortcuts.vala"
			_tmp72_ = bookworm_app_app_window_book_reading_footer_box;
#line 116 "../src/shortcuts.vala"
			gtk_widget_hide ((GtkWidget*) _tmp72_);
#line 117 "../src/shortcuts.vala"
			_tmp73_ = bookworm_app_bookworm_window;
#line 117 "../src/shortcuts.vala"
			gtk_window_fullscreen ((GtkWindow*) _tmp73_);
#line 651 "shortcuts.c"
		}
#line 119 "../src/shortcuts.vala"
		result = TRUE;
#line 119 "../src/shortcuts.vala"
		return result;
#line 657 "shortcuts.c"
	}
#line 122 "../src/shortcuts.vala"
	if (bookworm_app_shortcuts_isControlKeyPressed) {
#line 661 "shortcuts.c"
		gboolean _tmp75_ = FALSE;
#line 122 "../src/shortcuts.vala"
		if (ev->keyval == GDK_KEY_Q) {
#line 122 "../src/shortcuts.vala"
			_tmp75_ = TRUE;
#line 667 "shortcuts.c"
		} else {
#line 122 "../src/shortcuts.vala"
			_tmp75_ = ev->keyval == GDK_KEY_q;
#line 671 "shortcuts.c"
		}
#line 122 "../src/shortcuts.vala"
		_tmp74_ = _tmp75_;
#line 675 "shortcuts.c"
	} else {
#line 122 "../src/shortcuts.vala"
		_tmp74_ = FALSE;
#line 679 "shortcuts.c"
	}
#line 122 "../src/shortcuts.vala"
	if (_tmp74_) {
#line 683 "shortcuts.c"
		GtkApplicationWindow* _tmp76_;
#line 123 "../src/shortcuts.vala"
		_tmp76_ = bookworm_app_bookworm_window;
#line 123 "../src/shortcuts.vala"
		gtk_widget_destroy ((GtkWidget*) _tmp76_);
#line 689 "shortcuts.c"
	}
#line 126 "../src/shortcuts.vala"
	if (bookworm_app_shortcuts_isControlKeyPressed) {
#line 693 "shortcuts.c"
		gboolean _tmp78_ = FALSE;
#line 126 "../src/shortcuts.vala"
		if (ev->keyval == GDK_KEY_F) {
#line 126 "../src/shortcuts.vala"
			_tmp78_ = TRUE;
#line 699 "shortcuts.c"
		} else {
#line 126 "../src/shortcuts.vala"
			_tmp78_ = ev->keyval == GDK_KEY_f;
#line 703 "shortcuts.c"
		}
#line 126 "../src/shortcuts.vala"
		_tmp77_ = _tmp78_;
#line 707 "shortcuts.c"
	} else {
#line 126 "../src/shortcuts.vala"
		_tmp77_ = FALSE;
#line 711 "shortcuts.c"
	}
#line 126 "../src/shortcuts.vala"
	if (_tmp77_) {
#line 715 "shortcuts.c"
		GtkSearchEntry* _tmp79_;
#line 127 "../src/shortcuts.vala"
		_tmp79_ = bookworm_app_app_header_bar_headerSearchBar;
#line 127 "../src/shortcuts.vala"
		gtk_widget_grab_focus ((GtkWidget*) _tmp79_);
#line 721 "shortcuts.c"
	}
#line 129 "../src/shortcuts.vala"
	result = FALSE;
#line 129 "../src/shortcuts.vala"
	return result;
#line 727 "shortcuts.c"
}

gboolean
bookworm_app_shortcuts_handleKeyRelease (GdkEventKey* ev)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
#line 132 "../src/shortcuts.vala"
	g_return_val_if_fail (ev != NULL, FALSE);
#line 134 "../src/shortcuts.vala"
	if (ev->keyval == GDK_KEY_Control_L) {
#line 134 "../src/shortcuts.vala"
		_tmp0_ = TRUE;
#line 741 "shortcuts.c"
	} else {
#line 134 "../src/shortcuts.vala"
		_tmp0_ = ev->keyval == GDK_KEY_Control_R;
#line 745 "shortcuts.c"
	}
#line 134 "../src/shortcuts.vala"
	if (_tmp0_) {
#line 135 "../src/shortcuts.vala"
		bookworm_app_shortcuts_isControlKeyPressed = FALSE;
#line 751 "shortcuts.c"
	}
#line 137 "../src/shortcuts.vala"
	result = FALSE;
#line 137 "../src/shortcuts.vala"
	return result;
#line 757 "shortcuts.c"
}

BookwormAppShortcuts*
bookworm_app_shortcuts_construct (GType object_type)
{
	BookwormAppShortcuts * self = NULL;
#line 20 "../src/shortcuts.vala"
	self = (BookwormAppShortcuts*) gtk_widget_new (object_type, NULL);
#line 20 "../src/shortcuts.vala"
	return self;
#line 768 "shortcuts.c"
}

BookwormAppShortcuts*
bookworm_app_shortcuts_new (void)
{
#line 20 "../src/shortcuts.vala"
	return bookworm_app_shortcuts_construct (BOOKWORM_APP_TYPE_SHORTCUTS);
#line 776 "shortcuts.c"
}

static void
bookworm_app_shortcuts_class_init (BookwormAppShortcutsClass * klass,
                                   gpointer klass_data)
{
#line 20 "../src/shortcuts.vala"
	bookworm_app_shortcuts_parent_class = g_type_class_peek_parent (klass);
#line 20 "../src/shortcuts.vala"
	G_OBJECT_CLASS (klass)->finalize = bookworm_app_shortcuts_finalize;
#line 787 "shortcuts.c"
}

static void
bookworm_app_shortcuts_instance_init (BookwormAppShortcuts * self,
                                      gpointer klass)
{
}

static void
bookworm_app_shortcuts_finalize (GObject * obj)
{
	BookwormAppShortcuts * self;
#line 20 "../src/shortcuts.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BOOKWORM_APP_TYPE_SHORTCUTS, BookwormAppShortcuts);
#line 20 "../src/shortcuts.vala"
	G_OBJECT_CLASS (bookworm_app_shortcuts_parent_class)->finalize (obj);
#line 804 "shortcuts.c"
}

static GType
bookworm_app_shortcuts_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BookwormAppShortcutsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) bookworm_app_shortcuts_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BookwormAppShortcuts), 0, (GInstanceInitFunc) bookworm_app_shortcuts_instance_init, NULL };
	GType bookworm_app_shortcuts_type_id;
	bookworm_app_shortcuts_type_id = g_type_register_static (gtk_widget_get_type (), "BookwormAppShortcuts", &g_define_type_info, 0);
	return bookworm_app_shortcuts_type_id;
}

GType
bookworm_app_shortcuts_get_type (void)
{
	static volatile gsize bookworm_app_shortcuts_type_id__once = 0;
	if (g_once_init_enter (&bookworm_app_shortcuts_type_id__once)) {
		GType bookworm_app_shortcuts_type_id;
		bookworm_app_shortcuts_type_id = bookworm_app_shortcuts_get_type_once ();
		g_once_init_leave (&bookworm_app_shortcuts_type_id__once, bookworm_app_shortcuts_type_id);
	}
	return bookworm_app_shortcuts_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

