# Generated by default/object.tt
package Paws::ACMPCA::PolicyQualifierInfo;
  use Moose;
  has PolicyQualifierId => (is => 'ro', isa => 'Str', required => 1);
  has Qualifier => (is => 'ro', isa => 'Paws::ACMPCA::Qualifier', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::ACMPCA::PolicyQualifierInfo

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::ACMPCA::PolicyQualifierInfo object:

  $service_obj->Method(Att1 => { PolicyQualifierId => $value, ..., Qualifier => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::ACMPCA::PolicyQualifierInfo object:

  $result = $service_obj->Method(...);
  $result->Att1->PolicyQualifierId

=head1 DESCRIPTION

Modifies the C<CertPolicyId> of a C<PolicyInformation> object with a
qualifier. ACM Private CA supports the certification practice statement
(CPS) qualifier.

=head1 ATTRIBUTES


=head2 B<REQUIRED> PolicyQualifierId => Str

Identifies the qualifier modifying a C<CertPolicyId>.


=head2 B<REQUIRED> Qualifier => L<Paws::ACMPCA::Qualifier>

Defines the qualifier type. ACM Private CA supports the use of a URI
for a CPS qualifier in this field.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::ACMPCA>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

