/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.internal.util;

import java.util.BitSet;
import java.util.NoSuchElementException;
import org.apache.uima.internal.util.IntListIterator;
import org.apache.uima.internal.util.IntVector;
import org.apache.uima.internal.util.PositiveIntSet;
import org.apache.uima.internal.util.PositiveIntSet_impl;

public class IntBitSet
implements PositiveIntSet {
    private final BitSet set;
    private int size = 0;
    private final int offset;

    public int getOffset() {
        return this.offset;
    }

    public IntBitSet() {
        this(63);
    }

    public IntBitSet(int maxInt) {
        this(maxInt, 0);
    }

    public IntBitSet(int maxAdjKey, int offset) {
        this.set = new BitSet(Math.max(1, maxAdjKey));
        this.offset = offset;
    }

    @Override
    public void clear() {
        this.set.clear();
        this.size = 0;
    }

    @Override
    public boolean contains(int key) {
        return key == 0 ? false : (key - this.offset < 0 ? false : this.set.get(key - this.offset));
    }

    @Override
    public int find(int element) {
        return this.contains(element) ? element - this.offset : -1;
    }

    @Override
    public boolean add(int original_key) {
        if (original_key < this.offset) {
            throw new IllegalArgumentException("key " + original_key + " must be greater than or equal to the offset: " + this.offset);
        }
        int adjKey = original_key - this.offset;
        boolean prev = this.set.get(adjKey);
        this.set.set(adjKey);
        if (!prev) {
            ++this.size;
            return true;
        }
        return false;
    }

    @Override
    public boolean remove(int original_key) {
        int adjKey = original_key - this.offset;
        if (adjKey < 0) {
            return false;
        }
        boolean prev = this.set.get(adjKey);
        if (prev) {
            this.set.clear(adjKey);
            --this.size;
            return true;
        }
        return false;
    }

    @Override
    public int size() {
        return this.size;
    }

    public int getSpaceUsed_in_bits_no_overhead() {
        return this.set.size();
    }

    public int getSpaceUsed_in_words_no_overhead() {
        return this.getSpaceUsed_in_bits_no_overhead() >> 5;
    }

    public int getLargestMenber() {
        return this.set.length() - 1 + this.offset;
    }

    @Override
    public int get(int position) {
        assert (this.set.get(position));
        return position + this.offset;
    }

    @Override
    public IntBitSetIterator iterator() {
        return new IntBitSetIterator();
    }

    @Override
    public int moveToFirst() {
        return this.set.nextSetBit(0);
    }

    @Override
    public int moveToLast() {
        return this.set.length() - 1;
    }

    @Override
    public int moveToNext(int position) {
        return position < 0 ? position : this.set.nextSetBit(position + 1);
    }

    @Override
    public int moveToPrevious(int position) {
        return position < 0 ? position : this.set.previousSetBit(position - 1);
    }

    @Override
    public boolean isValid(int position) {
        return position >= 0 && this.set.get(position);
    }

    @Override
    public void bulkAddTo(IntVector v) {
        int pos = -1;
        while (-1 != (pos = this.set.nextSetBit(pos + 1))) {
            v.add(pos + this.offset);
        }
    }

    @Override
    public int[] toIntArray() {
        int s = this.size();
        if (s == 0) {
            return PositiveIntSet_impl.EMPTY_INT_ARRAY;
        }
        int[] r = new int[s];
        int pos = this.moveToFirst();
        for (int i = 0; i < s; ++i) {
            r[i] = this.get(pos);
            pos = this.set.nextSetBit(pos + 1);
        }
        return r;
    }

    public String toString() {
        return String.format("IntBitSet [set=%s, size=%s, offset=%s]", this.set, this.size, this.offset);
    }

    private class IntBitSetIterator
    implements IntListIterator {
        protected int curKey;

        protected IntBitSetIterator() {
            this.curKey = IntBitSet.this.set.nextSetBit(0);
        }

        @Override
        public final boolean hasNext() {
            return this.curKey >= 0;
        }

        @Override
        public final int next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            int r = this.curKey;
            this.curKey = IntBitSet.this.set.nextSetBit(this.curKey + 1);
            return r + IntBitSet.this.offset;
        }

        @Override
        public boolean hasPrevious() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int previous() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void moveToEnd() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void moveToStart() {
            this.curKey = IntBitSet.this.set.nextSetBit(0);
        }
    }
}

