/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.jaxb.gmd;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.XmlValue;
import org.apache.sis.internal.jaxb.Context;
import org.apache.sis.internal.jaxb.gmd.CodeListAdapter;
import org.apache.sis.util.iso.Types;
import org.opengis.util.CodeList;

@XmlType(name="CodeList", propOrder={"codeList", "codeListValue", "codeSpace"})
public final class CodeListUID {
    @XmlAttribute(required=true)
    public String codeList;
    @XmlAttribute(required=true)
    public String codeListValue;
    @XmlAttribute
    public String codeSpace;
    @XmlValue
    public String value;

    private static String schema(Context context, String string) {
        return Context.schema(context, "gmd", "http://schemas.opengis.net/iso/19139/20070417/").append("resources/Codelist/gmxCodelists.xml").append('#').append(string).toString();
    }

    CodeListUID() {
    }

    public CodeListUID(Context context, String string, String string2, String string3, String string4) {
        this.codeList = CodeListUID.schema(context, string);
        this.codeListValue = string2;
        this.codeSpace = string3;
        this.value = string4;
    }

    public CodeListUID(Context context, CodeList<?> codeList) {
        String string = Types.getListName(codeList);
        String string2 = Types.getCodeName(codeList);
        this.codeList = CodeListUID.schema(context, string);
        Locale locale = context.getLocale();
        if (locale != null) {
            String string3 = string + '.' + string2;
            try {
                this.value = ResourceBundle.getBundle("org.opengis.metadata.CodeLists", locale, CodeList.class.getClassLoader()).getString(string3);
            }
            catch (MissingResourceException missingResourceException) {
                Context.warningOccured(context, CodeListAdapter.class, "marshal", missingResourceException, false);
            }
        }
        if (this.value != null) {
            this.codeSpace = Context.converter(context).toLanguageCode(context, locale);
        } else {
            this.value = Types.getCodeLabel(codeList);
        }
        this.codeListValue = string2;
    }

    public String toString() {
        String string = this.codeListValue;
        if (string == null) {
            string = this.value;
        }
        return string;
    }
}

