use warnings;
use strict;

use Test::More tests => 31*3;

my $test_input = "\x01\x02\x04\x08\x10\x20\x40\x80";
my $f;

open($f, "<:bitswap(0)", \$test_input);
$/ = \1;
is scalar(<$f>), "\x01";
is scalar(<$f>), "\x02";
is scalar(<$f>), "\x04";
is scalar(<$f>), "\x08";
is scalar(<$f>), "\x10";
is scalar(<$f>), "\x20";
is scalar(<$f>), "\x40";
is scalar(<$f>), "\x80";
is scalar(<$f>), undef;
is scalar(<$f>), undef;
$f = undef;

open($f, "<:bitswap(0)", \$test_input);
$/ = \1;
ok !eof($f);
is scalar(<$f>), "\x01";
ok !eof($f);
is scalar(<$f>), "\x02";
ok !eof($f);
is scalar(<$f>), "\x04";
ok !eof($f);
is scalar(<$f>), "\x08";
ok !eof($f);
is scalar(<$f>), "\x10";
ok !eof($f);
is scalar(<$f>), "\x20";
ok !eof($f);
is scalar(<$f>), "\x40";
ok !eof($f);
is scalar(<$f>), "\x80";
ok eof($f);
is scalar(<$f>), undef;
ok eof($f);
is scalar(<$f>), undef;
ok eof($f);
$f = undef;

open($f, "<:bitswap(4)", \$test_input);
$/ = \1;
is scalar(<$f>), "\x10";
is scalar(<$f>), "\x20";
is scalar(<$f>), "\x40";
is scalar(<$f>), "\x80";
is scalar(<$f>), "\x01";
is scalar(<$f>), "\x02";
is scalar(<$f>), "\x04";
is scalar(<$f>), "\x08";
is scalar(<$f>), undef;
is scalar(<$f>), undef;
$f = undef;

open($f, "<:bitswap(4)", \$test_input);
$/ = \1;
ok !eof($f);
is scalar(<$f>), "\x10";
ok !eof($f);
is scalar(<$f>), "\x20";
ok !eof($f);
is scalar(<$f>), "\x40";
ok !eof($f);
is scalar(<$f>), "\x80";
ok !eof($f);
is scalar(<$f>), "\x01";
ok !eof($f);
is scalar(<$f>), "\x02";
ok !eof($f);
is scalar(<$f>), "\x04";
ok !eof($f);
is scalar(<$f>), "\x08";
ok eof($f);
is scalar(<$f>), undef;
ok eof($f);
is scalar(<$f>), undef;
ok eof($f);
$f = undef;

open($f, "<:bitswap(8)", \$test_input);
$/ = \1;
is scalar(<$f>), "\x02";
is scalar(<$f>), "\x01";
is scalar(<$f>), "\x08";
is scalar(<$f>), "\x04";
is scalar(<$f>), "\x20";
is scalar(<$f>), "\x10";
is scalar(<$f>), "\x80";
is scalar(<$f>), "\x40";
is scalar(<$f>), undef;
is scalar(<$f>), undef;
$f = undef;

open($f, "<:bitswap(8)", \$test_input);
$/ = \1;
ok !eof($f);
is scalar(<$f>), "\x02";
ok !eof($f);
is scalar(<$f>), "\x01";
ok !eof($f);
is scalar(<$f>), "\x08";
ok !eof($f);
is scalar(<$f>), "\x04";
ok !eof($f);
is scalar(<$f>), "\x20";
ok !eof($f);
is scalar(<$f>), "\x10";
ok !eof($f);
is scalar(<$f>), "\x80";
ok !eof($f);
is scalar(<$f>), "\x40";
ok eof($f);
is scalar(<$f>), undef;
ok eof($f);
is scalar(<$f>), undef;
ok eof($f);
$f = undef;

1;
