#define PERL_NO_GET_CONTEXT

#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"

#include "XSParseInfix.h"

#define sv_defined(sv) (sv && (SvIOK(sv) || SvNOK(sv) || SvPOK(sv) || SvROK(sv)))

static OP *pp_matches( pTHX )
{
  dSP;
  dTARG;
  SV *b = TOPs, *a = TOPm1s;

  SvGETMAGIC( a );
  SvGETMAGIC( b );

  if ( ! sv_defined( b ) ) {
     POPs;
     SETs( sv_defined( a ) ? &PL_sv_no : &PL_sv_yes );
  }

  else if ( ! SvROK( b ) ) {
    POPs;
    SETs( sv_eq( a, b ) ? &PL_sv_yes : &PL_sv_no );
  }

  else if ( sv_isobject( b ) && sv_derived_from( b, "Type::Tiny" ) ) {
    int count;
    SV *ret;
    bool ret_truth;
    ENTER;
    SAVETMPS;
    PUSHMARK(SP);
    XPUSHs(b);
    XPUSHs(a);
    PUTBACK;
    count = call_method( "check", G_SCALAR );
    SPAGAIN;
    ret = POPs;
    ret_truth = SvTRUE( ret );
    PUTBACK;
    FREETMPS;
    LEAVE;

    POPs;
    SETs( ret_truth ? &PL_sv_yes : &PL_sv_no );
  }
  else {
    int count;
    bool r;
    ENTER;
    SAVETMPS;
    PUSHMARK( SP );
    XPUSHs( a );
    XPUSHs( b );
    PUTBACK;
    count = call_pv( "match::simple::match", G_SCALAR );
    SPAGAIN;
    r = POPi;
    PUTBACK;
    FREETMPS;
    LEAVE;

    POPs;
    SETs( r != 0 ? &PL_sv_yes : &PL_sv_no );
  }

  RETURN;
}

static const struct XSParseInfixHooks hooks_matches = {
  .cls               = XPI_CLS_MATCH_MISC,
  .permit_hintkey    = "Syntax::Operator::Matches/matches",
  .ppaddr            = &pp_matches,
};

MODULE = Syntax::Operator::Matches    PACKAGE = Syntax::Operator::Matches

BOOT:
  boot_xs_parse_infix( 0.26 );
  register_xs_parse_infix( "matches", &hooks_matches, NULL );
