### The DnD system at runtime, in real time (RT)

use EyeofTheBeholder::DnDStamina;
use EyeofTheBeholder::DnDHP;
use EyeofTheBeholder::DnDXP;

class EyeofTheBeholder::DnDCharRTSys {

	has $!stamina; ### stamina points (wrapped)
	has $!hp; ### hit points (wrapped)
	has $!xp; ### experience points (wrapped)

	has $!maxstamina; ### maximum stamina points (wrapped)
	has $!maxhp; ### maximum hit points (wrapped)

	### max xp mods are for e.g. exhaustion levels or drains
	has $!maxxp; ### maximum experience points (wrapped)

       submethod BUILD(:$sp, :$hp, $:xp) {

		$!stamina = DnDStamina.new.set($sp);
		$!hp = DnDHP.new.set($hp);
		$!xp = DnDXP.new.set($xp);

		$!maxstamina = $!stamina;
		$!maxhp = $!hp;
		$!maxxp = $!xp;

		### self.init;
		
	}

	### adds to stats
	submethod add-to-stamina($plus) {

		$!stamina.add($plus);

	}

	submethod add-to-hp($plus) {

		$!hp.add($plus);

	}

	submethod add-to-xp($plus) {

		$!xp.add($plus);

	}

	### substracts from stats
	submethod sub-to-stamina($minus) {

		$!stamina.sub($minus);

	}

	submethod sub-to-hp($minus) {

		$!hp.sub($minus);

	}

	submethod sub-to-xp($minus) {

		$!xp.sub($minus);

	}

	### adds to max points
	submethod add-to-max-stamina($plus) {

		$!maxstamina.add($plus);

	}

	submethod add-to-max-hp($plus) {

		$!maxhp.add($plus);

	}

	submethod add-to-max-xp($plus) {

		$!maxxp.add($plus);

	}

	### substracts from max points
	submethod sub-to-max-stamina($minus) {

		$!maxstamina.sub($minus);

	}

	submethod sub-to-max-hp($minus) {

		$!maxhp.sub($minus);

	}

	submethod sub-to-max-xp($minus) {

		$!maxxp.sub($minus);

	}


}
