use strict;
use ExtUtils::MakeMaker 6.17;

my $EUMM = eval( $ExtUtils::MakeMaker::VERSION );

my $meta = {
  "abstract"         => "simple spreadsheet worker",
  "author"           => ["Toby Inkster (TOBYINK) <tobyink\@cpan.org>"],
  "dynamic_config"   => 0,
  "generated_by"     => "Dist::Inkt::Profile::TOBYINK version 0.024, CPAN::Meta::Converter version 2.150010",
  "keywords"         => [],
  "license"          => ["perl_5"],
  "meta-spec"        => {
                          url => "http://search.cpan.org/perldoc?CPAN::Meta::Spec",
                          version => 2,
                        },
  "name"             => "Spreadsheet-Wright",
  "no_index"         => { directory => ["eg", "examples", "inc", "t", "xt"] },
  "prereqs"          => {
                          configure => { requires => { "ExtUtils::MakeMaker" => 6.17 } },
                          runtime => {
                            recommends => {
                                            "Archive::Zip" => 0,
                                            "DateTime" => 0,
                                            "HTML::HTML5::Writer" => 0,
                                            "JSON" => 0,
                                            "Spreadsheet::WriteExcel" => 0,
                                            "XML::LibXML" => 1.62,
                                          },
                            requires   => { "parent" => 0, "perl" => "5.010000", "Text::CSV" => 0 },
                          },
                          test => { requires => { "Test::More" => 0.61 } },
                        },
  "provides"         => {
                          "Spreadsheet::Wright"                  => { file => "lib/Spreadsheet/Wright.pm", version => 0.107 },
                          "Spreadsheet::Wright::CSV"             => { file => "lib/Spreadsheet/Wright/CSV.pm", version => 0.107 },
                          "Spreadsheet::Wright::Excel"           => { file => "lib/Spreadsheet/Wright/Excel.pm", version => 0.107 },
                          "Spreadsheet::Wright::HTML"            => { file => "lib/Spreadsheet/Wright/HTML.pm", version => 0.107 },
                          "Spreadsheet::Wright::JSON"            => { file => "lib/Spreadsheet/Wright/JSON.pm", version => 0.107 },
                          "Spreadsheet::Wright::OOXML"           => { file => "lib/Spreadsheet/Wright/OOXML.pm", version => 0.107 },
                          "Spreadsheet::Wright::OpenDocument"    => { file => "lib/Spreadsheet/Wright/OpenDocument.pm", version => 0.107 },
                          "Spreadsheet::Wright::OpenDocumentXML" => {
                                                                      file => "lib/Spreadsheet/Wright/OpenDocumentXML.pm",
                                                                      version => 0.107,
                                                                    },
                          "Spreadsheet::Wright::XHTML"           => { file => "lib/Spreadsheet/Wright/XHTML.pm", version => 0.107 },
                        },
  "release_status"   => "stable",
  "resources"        => {
                          bugtracker   => {
                                            web => "http://rt.cpan.org/Dist/Display.html?Queue=Spreadsheet-Wright",
                                          },
                          homepage     => "https://metacpan.org/release/Spreadsheet-Wright",
                          license      => ["http://dev.perl.org/licenses/"],
                          repository   => {
                                            type => "git",
                                            url  => "git://github.com/tobyink/p5-spreadsheet-wright.git",
                                            web  => "https://github.com/tobyink/p5-spreadsheet-wright",
                                          },
                          x_identifier => "http://purl.org/NET/cpan-uri/dist/Spreadsheet-Wright/project",
                        },
  "version"          => 0.107,
  "x_contributors"   => [
                          "Andrew Maltsev (AMALTSEV) <amaltsev\@cpan.org>",
                          "Andrius Merkys (MERKYS) <merkys\@cpan.org>",
                        ],
  "x_static_install" => 1,
};

my %dynamic_config;

my %WriteMakefileArgs = (
	ABSTRACT   => $meta->{abstract},
	AUTHOR     => ($EUMM >= 6.5702 ? $meta->{author} : $meta->{author}[0]),
	DISTNAME   => $meta->{name},
	VERSION    => $meta->{version},
	EXE_FILES  => [ map $_->{file}, values %{ $meta->{x_provides_scripts} || {} } ],
	NAME       => do { my $n = $meta->{name}; $n =~ s/-/::/g; $n },
	test       => { TESTS => "t/*.t" },
	%dynamic_config,
);

$WriteMakefileArgs{LICENSE} = $meta->{license}[0] if $EUMM >= 6.3001;

sub deps
{
	my %r;
	for my $stage (@_)
	{
		for my $dep (keys %{$meta->{prereqs}{$stage}{requires}})
		{
			next if $dep eq 'perl';
			my $ver = $meta->{prereqs}{$stage}{requires}{$dep};
			$r{$dep} = $ver if !exists($r{$dep}) || $ver >= $r{$dep};
		}
	}
	\%r;
}

my ($build_requires, $configure_requires, $runtime_requires, $test_requires);
if ($EUMM >= 6.6303)
{
	$WriteMakefileArgs{BUILD_REQUIRES}     ||= deps('build');
	$WriteMakefileArgs{CONFIGURE_REQUIRES} ||= deps('configure');
	$WriteMakefileArgs{TEST_REQUIRES}      ||= deps('test');
	$WriteMakefileArgs{PREREQ_PM}          ||= deps('runtime');
}
elsif ($EUMM >= 6.5503)
{
	$WriteMakefileArgs{BUILD_REQUIRES}     ||= deps('build', 'test');
	$WriteMakefileArgs{CONFIGURE_REQUIRES} ||= deps('configure');
	$WriteMakefileArgs{PREREQ_PM}          ||= deps('runtime');	
}
elsif ($EUMM >= 6.52)
{
	$WriteMakefileArgs{CONFIGURE_REQUIRES} ||= deps('configure');
	$WriteMakefileArgs{PREREQ_PM}          ||= deps('runtime', 'build', 'test');	
}
else
{
	$WriteMakefileArgs{PREREQ_PM}          ||= deps('configure', 'build', 'test', 'runtime');	
}

{
	my ($minperl) = reverse sort(
		grep defined && /^[0-9]+(\.[0-9]+)?$/,
		map $meta->{prereqs}{$_}{requires}{perl},
		qw( configure build runtime )
	);
	
	if (defined($minperl))
	{
		die "Installing $meta->{name} requires Perl >= $minperl"
			unless $] >= $minperl;
		
		$WriteMakefileArgs{MIN_PERL_VERSION} ||= $minperl
			if $EUMM >= 6.48;
	}
}

sub FixMakefile
{
	return unless -d 'inc';
	my $file = shift;
	
	local *MAKEFILE;
	open MAKEFILE, "< $file" or die "FixMakefile: Couldn't open $file: $!; bailing out";
	my $makefile = do { local $/; <MAKEFILE> };
	close MAKEFILE or die $!;
	
	$makefile =~ s/\b(test_harness\(\$\(TEST_VERBOSE\), )/$1'inc', /;
	$makefile =~ s/( -I\$\(INST_ARCHLIB\))/ -Iinc$1/g;
	$makefile =~ s/( "-I\$\(INST_LIB\)")/ "-Iinc"$1/g;
	$makefile =~ s/^(FULLPERL = .*)/$1 "-Iinc"/m;
	$makefile =~ s/^(PERL = .*)/$1 "-Iinc"/m;
	
	open  MAKEFILE, "> $file" or die "FixMakefile: Couldn't open $file: $!; bailing out";
	print MAKEFILE $makefile or die $!;
	close MAKEFILE or die $!;
}

my $mm = WriteMakefile(%WriteMakefileArgs);
FixMakefile($mm->{FIRST_MAKEFILE} || 'Makefile');
exit(0);

