/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.io.wkt;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Classes;
import org.apache.sis.util.Exceptions;
import org.apache.sis.util.Localized;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.util.resources.IndexedResourceBundle;
import org.apache.sis.util.resources.Messages;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.util.InternationalString;

public final class Warnings
implements Localized,
Serializable {
    private static final long serialVersionUID = -1825161781642905329L;
    private final Locale errorLocale;
    private final boolean isParsing;
    private String root;
    private List<Object> messages;
    private Map<Exception, String[]> exceptionSources;
    private Map<String, List<String>> ignoredElements;
    private boolean published;

    Warnings(Locale locale, boolean bl, Map<String, List<String>> map) {
        this.errorLocale = locale;
        this.isParsing = bl;
        this.ignoredElements = map;
    }

    final void setRoot(Object object) {
        ReferenceIdentifier referenceIdentifier;
        if (object instanceof IdentifiedObject && (referenceIdentifier = ((IdentifiedObject)object).getName()) != null && (this.root = referenceIdentifier.getCode()) != null) {
            return;
        }
        this.root = Classes.getShortClassName(object);
    }

    final void add(InternationalString internationalString, Exception exception, String[] stringArray) {
        assert (internationalString != null || exception != null);
        if (this.messages == null) {
            this.messages = new ArrayList<Object>(4);
        }
        this.messages.add(internationalString);
        this.messages.add(exception);
        if (exception != null) {
            if (this.exceptionSources == null) {
                this.exceptionSources = new LinkedHashMap<Exception, String[]>(4);
            }
            this.exceptionSources.put(exception, stringArray);
        }
    }

    final void publish() {
        if (!this.published) {
            this.ignoredElements = this.ignoredElements.isEmpty() ? Collections.emptyMap() : new LinkedHashMap<String, List<String>>(this.ignoredElements);
            this.published = true;
        }
    }

    @Override
    public Locale getLocale() {
        return this.errorLocale;
    }

    public String getRootElement() {
        return this.root;
    }

    public final int getNumMessages() {
        return this.messages != null ? this.messages.size() / 2 : 0;
    }

    public String getMessage(int n) {
        ArgumentChecks.ensureValidIndex(this.getNumMessages(), n);
        InternationalString internationalString = (InternationalString)this.messages.get(n *= 2);
        if (internationalString != null) {
            return internationalString.toString(this.errorLocale);
        }
        Exception exception = (Exception)this.messages.get(n + 1);
        String[] stringArray = this.exceptionSources.get(exception);
        if (stringArray != null) {
            return Errors.getResources(this.errorLocale).getString((short)156, stringArray);
        }
        return exception.toString();
    }

    public Exception getException(int n) {
        ArgumentChecks.ensureValidIndex(this.getNumMessages(), n);
        return (Exception)this.messages.get(n * 2 + 1);
    }

    public Set<Exception> getExceptions() {
        return this.exceptionSources != null ? this.exceptionSources.keySet() : Collections.emptySet();
    }

    public String[] getExceptionSource(Exception exception) {
        return this.exceptionSources != null ? this.exceptionSources.get(exception) : null;
    }

    public Set<String> getUnknownElements() {
        return this.ignoredElements.keySet();
    }

    public Collection<String> getUnknownElementLocations(String string) {
        return this.ignoredElements.get(string);
    }

    public String toString() {
        return this.toString(this.errorLocale);
    }

    /*
     * WARNING - void declaration
     */
    public String toString(Locale locale) {
        String string;
        Object object;
        StringBuilder stringBuilder = new StringBuilder(250);
        String string2 = System.lineSeparator();
        Messages messages = Messages.getResources(locale);
        stringBuilder.append(messages.getString(this.isParsing ? (short)22 : 26, this.root));
        if (this.messages != null) {
            object = this.messages.iterator();
            while (object.hasNext()) {
                void object3;
                Object object2;
                InternationalString internationalString = (InternationalString)object.next();
                Exception exception = (Exception)object.next();
                if (internationalString != null) {
                    string = internationalString.toString(locale);
                } else {
                    object2 = this.exceptionSources.get(exception);
                    if (object2 != null) {
                        string = Errors.getResources(locale).getString((short)156, object2);
                    } else {
                        string = exception.toString();
                        Object var7_9 = null;
                    }
                }
                stringBuilder.append(string2).append("\u00a0\u2022\u00a0").append(string);
                if (object3 == null) continue;
                object2 = Exceptions.getLocalizedMessage((Throwable)object3, locale);
                if (object2 == null) {
                    object2 = object3.toString();
                }
                stringBuilder.append(string2).append("\u00a0\u00a0\u00a0").append((String)object2);
            }
        }
        if (!this.ignoredElements.isEmpty()) {
            object = Vocabulary.getResources(locale);
            stringBuilder.append(string2).append("\u00a0\u2022\u00a0").append(messages.getString((short)29));
            for (Map.Entry entry : this.ignoredElements.entrySet()) {
                stringBuilder.append(string2).append("\u00a0\u00a0\u00a0\u00a0\u2023\u00a0").append(((IndexedResourceBundle)object).getString((short)87, entry.getKey()));
                string = ((IndexedResourceBundle)object).getString((short)50);
                for (String string3 : (List)entry.getValue()) {
                    stringBuilder.append(string).append(string3);
                    string = ", ";
                }
                stringBuilder.append('.');
            }
        }
        return stringBuilder.toString();
    }
}

