/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.encryption;

import java.io.IOException;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSString;

public class PDEncryptionDictionary {
    public static final int VERSION0_UNDOCUMENTED_UNSUPPORTED = 0;
    public static final int VERSION1_40_BIT_ALGORITHM = 1;
    public static final int VERSION2_VARIABLE_LENGTH_ALGORITHM = 2;
    public static final int VERSION3_UNPUBLISHED_ALGORITHM = 3;
    public static final int VERSION4_SECURITY_HANDLER = 4;
    public static final String DEFAULT_NAME = "Standard";
    public static final int DEFAULT_LENGTH = 40;
    public static final int DEFAULT_VERSION = 0;
    protected COSDictionary encryptionDictionary = null;

    public PDEncryptionDictionary() {
        this.encryptionDictionary = new COSDictionary();
    }

    public PDEncryptionDictionary(COSDictionary d) {
        this.encryptionDictionary = d;
    }

    public COSDictionary getCOSDictionary() {
        return this.encryptionDictionary;
    }

    public void setFilter(String filter) {
        this.encryptionDictionary.setItem(COSName.FILTER, (COSBase)COSName.getPDFName(filter));
    }

    public String getFilter() {
        return this.encryptionDictionary.getNameAsString(COSName.FILTER);
    }

    public void setSubFilter(String subfilter) {
        this.encryptionDictionary.setName("SubFilter", subfilter);
    }

    public void setVersion(int version) {
        this.encryptionDictionary.setInt("V", version);
    }

    public int getVersion() {
        return this.encryptionDictionary.getInt("V", 0);
    }

    public void setLength(int length) {
        this.encryptionDictionary.setInt("Length", length);
    }

    public int getLength() {
        return this.encryptionDictionary.getInt("Length", 40);
    }

    public void setRevision(int revision) {
        this.encryptionDictionary.setInt("R", revision);
    }

    public int getRevision() {
        return this.encryptionDictionary.getInt("R", 0);
    }

    public void setOwnerKey(byte[] o) throws IOException {
        COSString owner = new COSString();
        owner.append(o);
        this.encryptionDictionary.setItem(COSName.getPDFName("O"), (COSBase)owner);
    }

    public byte[] getOwnerKey() throws IOException {
        byte[] o = null;
        COSString owner = (COSString)this.encryptionDictionary.getDictionaryObject(COSName.getPDFName("O"));
        if (owner != null) {
            o = owner.getBytes();
        }
        return o;
    }

    public void setUserKey(byte[] u) throws IOException {
        COSString user = new COSString();
        user.append(u);
        this.encryptionDictionary.setItem(COSName.getPDFName("U"), (COSBase)user);
    }

    public byte[] getUserKey() throws IOException {
        byte[] u = null;
        COSString user = (COSString)this.encryptionDictionary.getDictionaryObject(COSName.getPDFName("U"));
        if (user != null) {
            u = user.getBytes();
        }
        return u;
    }

    public void setPermissions(int permissions) {
        this.encryptionDictionary.setInt("P", permissions);
    }

    public int getPermissions() {
        return this.encryptionDictionary.getInt("P", 0);
    }

    public void setRecipients(byte[][] recipients) throws IOException {
        COSArray array = new COSArray();
        for (int i = 0; i < recipients.length; ++i) {
            COSString recip = new COSString();
            recip.append(recipients[i]);
            recip.setForceLiteralForm(true);
            array.add(recip);
        }
        this.encryptionDictionary.setItem(COSName.getPDFName("Recipients"), (COSBase)array);
    }

    public int getRecipientsLength() {
        COSArray array = (COSArray)this.encryptionDictionary.getItem(COSName.getPDFName("Recipients"));
        return array.size();
    }

    public COSString getRecipientStringAt(int i) {
        COSArray array = (COSArray)this.encryptionDictionary.getItem(COSName.getPDFName("Recipients"));
        return (COSString)array.get(i);
    }
}

