package PROP::DBH;

use strict;
use DBI;
use PROP::Conf;

my $dbh = undef;

sub init_handle {
    my $conf = new PROP::Conf();

    my $source = join(':',
		      grep { defined $_ }
		      ('dbi',
		       $conf->get_dbd_name(),
		       $conf->get_database(),
		       $conf->get_host(),
		       $conf->get_port()));

    unless($dbh = DBI->connect($source, $conf->get_user(), $conf->get_password())) {
	my $msg = "could not connect to source '$source': $!";
	die new PROP::Exception($msg);
    }
}

sub get_handle {
    init_handle() unless $dbh;
    return $dbh;
}

1;

=head1 Name

PROP::DBH

=head1 Description

This is a class for obtaining database handles.  There exists just a
single static method, get_handle.

=head1 Methods

=over

=item get_handle

 $dbh = PROP::DBH::get_handle();

This method creates and returns a handle to a database as opened by
DBI->connect(...).  If a call to get_handle is made before information
about how to construct a handle has been specified, then a
PROP::Exception::Configuration exception will be thrown.  This
information can either be drawn from the environment variables
PROP_RDBMS and PPO_CNXNCONF, or can be set explicitly by invocations of
static methods that live within PROP::Conf.

=back

=head1 Author

Andrew Gibbs (awgibbs@awgibbs.com,andrew.gibbs@nist.gov)

=head1 Legalese

This software was developed at the National Institute of Standards and
Technology by employees of the Federal Government in the course of
their official duties. Pursuant to title 17 Section 105 of the United
States Code this software is not subject to copyright protection and
is in the public domain. PROP is an experimental system. NIST
assumes no responsibility whatsoever for its use by other parties, and
makes no guarantees, expressed or implied, about its quality,
reliability, or any other characteristic. We would appreciate
acknowledgement if the software is used.  This software can be
redistributed and/or modified freely provided that any derivative
works bear some notice that they are derived from it, and any modified
versions bear some notice that they have been modified.
