!ru:en
# NAME

config - Конфигуратор констант Perl-модуля

# VERSION

1.4.4

# SYNOPSIS

Файл lib/Weapons.pm:
```perl
package Weapons;

use config DAGGER => "mizericordia";

1;
```

Файл .config.pm:
```perl
package config;

config Weapons => (
    DAGGER => "horn",
);

1;
```

Что должно получиться:
```perl
use lib 'lib';
use Weapons;

Weapons::DAGGER # => horn
```

# DESCRIPTION

`use config` создаёт константу так же как `use constant`, но берёт значение из локального конфиг-файла проекта, если она там указана.

Файл конфига **./.config.pm** находится в корневой директории проекта.

Текущая директория в проекте должна соответствовать корню проекта.

Так как модуль прагмы `config.pm` перекрыт на <metacpan.org> файлом `config.pod` из пакета `WordNet-Similarity`, то используется этот мануал ([config::Manual](lib/config/Manual.md)).

# AUTHOR

Yaroslav O. Kosmina <dart@cpan.org>

# LICENSE

⚖ **Perl5**

# COPYRIGHT

The config module is copyright (c) 2023 Yaroslav O. Kosmina. Rusland. All rights reserved.